<?php

#add mailbox rss to dashboard
add_action('wp_dashboard_setup', 'my_dashboard_widgets');  

function my_dashboard_widgets() {  
     global $wp_meta_boxes;  
     // remove unnecessary widgets  
     // var_dump( $wp_meta_boxes['dashboard'] ); // use to get all the widget IDs  
     unset(  
          $wp_meta_boxes['dashboard']['normal']['core']['dashboard_plugins'],  
          $wp_meta_boxes['dashboard']['side']['core']['dashboard_secondary'],  
          $wp_meta_boxes['dashboard']['side']['core']['dashboard_primary']  
     );  
     // add a custom dashboard widget  
     wp_add_dashboard_widget( 'dashboard_custom_feed', 'Mailbox : Laatste Nieuws', 'dashboard_rssReader' ); //add new RSS feed output  
} 

function dashboard_rssReader() {  
	$message = "<div style='padding:5px;border:1px solid #eee;margin-bottom:15px;'>
     		Nuttige Links  : <a target='_blank' href='https://www.mailbox-marketing.be'>Website</a> | <a target='_blank' href='https://mailboxbvba.freshdesk.com/support/home'>Support</a> |
     		<a target='_blank' href='https://shop.wp-opleidingen.eu/'>Opleidingen</a> | <a target='_blank' href='https://www.facebook.com/mailboxbvba/'>Facebook</a></div>";
	 echo $message;
     echo '<div class="rss-widget">';  
     wp_widget_rss_output(array(  
          'url' => 'https://www.mailbox-marketing.be/feed',  //put your feed URL here  
          'title' => 'What\'s up from Adam Scott',  
          'items' => 4, //how many posts to show  
          'show_summary' => 1,  
          'show_author' => 0,  
          'show_date' => 1  
     ));  
     echo "</div>";      
}  


#reads an rss and adds the shortcode

// Simple RSS Shortcode
function mailbox_rss($atts) {
  extract(shortcode_atts(array(
  'size' => '10',
  'excerpt' => '30',
  'feed' => 'http://www.internoetics.com/feed/',
  'show_date' => 'false',
  'show_desc' => 'false',
  'heading' => 'span',
  'list' => 'true',
  'class' => 'rss',
  'title' => 'title',  
  'title_heading' => 'h3',
  'cache' => '1400'), $atts));

  include_once ABSPATH . WPINC . '/feed.php';
        //add_filter( 'wp_feed_cache_transient_lifetime', create_function( '$a', "$cache;" ) );

        $rss = fetch_feed($feed);
        
        if (!is_wp_error( $rss ) ) {

            $maxitems = $rss->get_item_quantity($size);
            $rss_items = $rss->get_items(0, $maxitems);

            $i = 0;
            $total_entries = count($rss_items);

            if ($list == true) $html = "<$title_heading>$title</$title_heading><ul class='$class'>";
            
            foreach ($rss_items as $item) {
                $i++;

                if( $total_entries == $i ) {
                    $last = " class='last'";
                } else {
                    $last = "";
                }

                $title = $item->get_title();
                $link = $item->get_permalink();
                $desc = $item->get_description();
                $date_posted = $item->get_date('d/m/Y');

    
    if ($list == "true") {
       // Output
       $html .= "<li id='post-$i'$last style='list-style: none;margin: 0; padding: 0;'>";
       $html .= "<$heading><a href='$link'>$title</a></$heading>";
       if( $show_date == "true" ) $html .= "<span class='date'>$date_posted</span>";
       if( $show_desc == "true" ) $html .= "<div class='rss-entry'>$desc</div>";
       $html .= "</li>";

       } elseif ($list == "false") {

       $html .= "<$heading><a href='$link'>$title</a></$heading>";
       if( $date == "true" ) $html .= "<span class='date'>$date_posted</span>";
       $html .= "<div class='rss-entry'>$desc</div>";
         }  
       }
       if ($list === true) $html .= "</ul>";
       } else {
       $html = "Error occurred while parsing your RSS feed. Visit the website at $feed.";
    }

return $html;
}

add_shortcode("rss", "mailbox_rss");



?>