<?php
/**
 * admin section of the plugin
 * v 1.0.0
 */
class mailbox_post_thumbs {

	//image formatting
	var $postid = 0;
	var $width = "50%";
	var $border = "1px solid #efefef";
	var $padding = "10px";
	var $background = "#ffffff;";
	var $opacity = "1";
	var $height="20vh";

	//cta formatting
	var $fontsize = "22px;";
	var $fontcolor = "#464646;";


	public function __construct() {
	}

	//integrates the styles for these thumbs
	function show_styles(){
		?>
		<style>
			.postthumb {
				height:<?php echo $this->height?>;
				float:left;
				width:<?php echo $this->width?>;
				border:<?php echo $this->border?>;
				padding:<?php echo $this->padding;?>}
			.postthumb .inner  {width:100%;height:100%;overflow:hidden;}
			.postthumb  {background-color:<?php echo $this->imgbackground;?>;overflow:hidden;}
			.postthumb img {width:100%;}
			.postthumb .inner:hover {opacity:0.5;}
			.postthumb .inner {background-size: cover;  background-position: center;}
		</style>
		<?php
	}

	//shows all the selected images
	function get_thumbs(){
		if ($this->postid==0) {return "";}

		$images = get_attached_media( 'image',$this->postid );
		if (!isset($images)){return "";}

		$this->show_styles();
		?>
		<div class="postthumbs">
			<?php foreach ($images as $image){
				$this->show_thumb($image);
			}?>
		</div>
		<?php
	}

	//show the detail of a thumb
	function show_thumb($image){
		$img_url= wp_get_attachment_image_src($image->ID,"large")[0];
	    $img_url_small = wp_get_attachment_image_src($image->ID,"medium")[0];
		$alt = get_post_meta($image->ID, '_wp_attachment_image_alt', true);
		?>
		<div class="postthumb fancybox" src="<?php echo $img_url?>" title="<?php echo $alt?>">
			<div class="inner" style="background-image:url('<?php echo $img_url_small?>');"></div>
		</div>
		<?php
	}

	//shows the cta as last thumb
	function show_cta(){}
}