<?php
/**
 * manages the interface for the grid
 * v 1.0.0
 */
class mailbox_grid_interface {
	public function __construct() {
	}
}


/**
 * management of the grid
 * v 1.0.0
 */
class mailbox_grid {
	var $categories = "";
	var $tags = "";
	var $posttypes="post";
	var $sort = "title";
	var $order = "ASC";
	var $status = "publish";
	var $search = "";
	var $customfield="";
	var $customvalue = "";
	var $parent = "";
	var $perpage = "100";
	var $paged = "0";
	var $placeholder = "div";
	var $width = "50%";
	var $border = "1px solid #efefef";
	var $padding = "10px";
	var $excerpt = 100;
	var $imgbackground = "#ffffff";
	var $margin = "0 10px 15px 0";
	var $taxonomy = "";
	var $terms = "";
	var $filtertax="";
	var $custommeta="";
	var $qty = 0;
	var $height = "auto";
	var $imageheight = "auto";
	var $class="";
	var $link = "";
	var $more = "";

	public function __construct() {

	}

	//start functions
	public function start(){
		
	}

	//enqueue the styles and javascripts
	function styles(){
		?>
		<style>
			.postgrid .item {width:<?php echo $this->width?>;height:<?php echo $this->height ?>;}
			.postgrid .item .inner  {margin:<?php echo $this->margin;?>;}
			.postgrid .item .image {background-color:<?php echo $this->imgbackground;?>;height:<?php echo $this->imageheight ?>;overflow:hidden;}
			.postgrid .item .image:hover img {opacity:0.5;height:auto;min-width:100%;}
			.postgrid .item .content {border:<?php echo $this->border?>;padding:<?php echo $this->padding;?>}
			
			@media only screen and (max-width : 768px) {
			  .postgrid .item {width:50%;}			 
			}

			@media only screen and (max-width : 480px) {
			  .postgrid .item {width:100%;height:auto;}
			   .postgrid .item .image {height:auto;}
			}
		</style>
		<?php
	}

	//shows a filter with buttons on a custom taxonomy
	function filter_tax(){
		if (strlen($this->filtertax)>0){
			$taxonomies = array($this->filtertax);

			$args = array(
			    'orderby'           => 'name',
			    'order'             => 'ASC',
			    'hide_empty'        => true,
			    'exclude'           => array(),
			    'exclude_tree'      => array(),
			    'include'           => array(),
			    'number'            => '',
			    'fields'            => 'all',
			    'slug'              => '',
			    'parent'            => '',
			    'hierarchical'      => true,
			    'child_of'          => 0,
			    'childless'         => false,
			    'get'               => '',
			    'name__like'        => '',
			    'description__like' => '',
			    'pad_counts'        => false,
			    'offset'            => '',
			    'search'            => '',
			    'cache_domain'      => 'core'
			);

			$terms = get_terms($taxonomies, $args);
			echo "<div id='query' data-slug=''  style='display:none;'></div>";
			echo "<div class='filtertax'>";

			?>
				<a href="#" class="filter selected" data-slug=""><?php echo _e("allemaal",'mailbox')?></a>
			<?php
			echo  $text;
			foreach($terms as $term){
				?>
				<a class="filter" href="#" data-slug="<?php echo $term->slug?>"><?php echo $term->name?> (<?php echo $term->count?>)</a>
				<?php
			}
			echo "</div>";

			?>
			<script>
				jQuery(document).ready(function($) {

					function show_data(){
						$(".postgrid .item").hide(400);

						var term = $("#query").attr("data-slug");

						if (term){
							$(".postgrid .item[data-slugs*='" + term + "']").show(0);
							}
						else {
							$(".postgrid .item").show(1000);
							}

					}

					$( "a.filter" ).click(function(event) {
						event.preventDefault();
						$(".filtertax a.filter").removeClass("selected");
						$(this).addClass("selected");
						var attr = $(this).attr("data-slug");
						$("#query").attr("data-slug",attr);
						show_data();
					});


				});

				</script>
			<?php
		}
	}

	//makes the selection the used data
	public function get_data(){

		//meta query
		$meta="";
		if (strlen($this->customfield)>0){
			$meta = array(
							'key'       => $this->customfield,
							'value'     => $this->customvalue,
							'compare'   => 'LIKE'
					)
			;
		}	
		

		$metadef = array(array('key' => '_thumbnail_id','compare' => 'EXISTS'),$meta);

		//tax query
		$taxquery="";
		if (strlen($this->taxonomy)>0){
			//$taxquery=array('taxonomy' => $this->taxonomy,'field'    => 'slug','terms'    => $this->terms);
			$taxquery=array(array('taxonomy' => $this->taxonomy,'field'    => 'slug','terms'    => $this->terms));
		}

		

		$args = array (
				'post_type'              => explode(",",$this->posttypes),
				'post_status'            => $this->status,
				's'                      => $this->search,
				'paged'					 => $this->paged,
				'pagination'             => true,
				'posts_per_page'         => $this->perpage,
				'order'                  => $this->order,
				'orderby'                => $this->sort,
				'meta_query'             => $metadef,
				'category_name'			 => $this->categories,
				'tag' 					 => $this->tags,
				'tax_query' 			 => $taxquery,				
		);
		
				// The Query
		$query = new WP_Query( $args );		
		wp_reset_postdata();
		return $query;
	}

	//creates the html for the grid
	public function create_grid(){
		$this->paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
		
		$data = $this->get_data();
		$this->styles();
		
		
		
		if ( $data->have_posts() ) {

		$this->filter_tax(); //show buttons with taxonomies
		?>
		<div class="postgrid">
			<div class="pagination">
				<?php				  
					$this->custom_pagination($data->max_num_pages,"",$this->paged);				  
				?>
			</div>
			<div class="items clearfix">
				<?php
					while ($data->have_posts()) {
						$data->the_post();
						$this->create_grid_item();
					}
				?>
			</div>
			<div class="bottom">
				<?php				  
					$this->custom_pagination($data->max_num_pages,"",$this->paged);				  
				?>
			</div>
		</div>
		<?php
		}
	}

	//creates the details of a grid item
	function create_grid_item(){
		$item = get_post(get_the_id());
		$post_thumbnail_id = get_post_thumbnail_id( $item->ID );
		$img = wp_get_attachment_image( $post_thumbnail_id, array(300,200) );
						
		$text = do_shortcode(get_the_content());
		//$text = substr(strip_tags($text),0,$this->excerpt);
		$text = apply_filters( 'the_content', wp_trim_words( strip_tags( $text ), $this->excerpt ) );
		
		$mylink = get_permalink();
		if (strlen($this->link)>0){
			$mylink = get_post_meta(get_the_id(),$this->link,true);
			$target= "_blank";
		}		

		?>
		<div data-slugs="<?php echo $this->get_post_terms($item->ID)?>" class="item <?php echo $this->class ?>">
			<a target="<?php echo $target ?>" href="<?php echo $mylink?>">
			<div class="inner">
				<div class="image">
					<?php echo $img?>
				</div>
				<div class="meta"></div>
				<div class="content">
					<div class="title"><?php echo $item->post_title ?></div>
					
					<div class='excerpt'><?php echo $text;?></div>
					<?php
					if ($this->custommeta){
						?>
						<div class="meta"><?php echo get_post_meta($item->ID,$this->custommeta,true) ?></div>
						<?php
					}
					?>
				</div>
				<?php if(strlen($this->more)>0){?>
				<div class="more"><?php echo $this->more?></div>
				<?php }?>
			</div>
			</a>
		</div>
		<?php

	}
	
	//custom pagination
	function custom_pagination($numpages = '', $pagerange = '', $paged='') {
		
	  if (empty($pagerange)) {
		$pagerange = 10;
	  }

	  global $paged;
	  if (empty($paged)) {
		$paged = 1;
	  }
	  if ($numpages == '') {
		global $wp_query;
		$numpages = $wp_query->max_num_pages;
		if(!$numpages) {
			$numpages = 1;
		}
	  }

	  /** 
	   * We construct the pagination arguments to enter into our paginate_links
	   * function. 
	   */
	  $pagination_args = array(
		'base'            => get_pagenum_link(1) . '%_%',
		'format'          => 'page/%#%',
		'total'           => $numpages,
		'current'         => $paged,
		'show_all'        => False,
		'end_size'        => 1,
		'mid_size'        => $pagerange,
		'prev_next'       => True,
		'prev_text'       => __('&laquo;'),
		'next_text'       => __('&raquo;'),
		'type'            => 'plain',
		'add_args'        => false,
		'add_fragment'    => ''
	  );

	  $paginate_links = paginate_links($pagination_args);
	  
	 

	  if ($paginate_links) {
		echo "<nav class='custom-pagination'>";
		  echo "<span class='page-numbers page-num'>Page " . $paged . " of " . $numpages . "</span> | ";
		  echo $paginate_links;
		echo "</nav>";
	  }

}

	//adds data to div about custom taxonomy
	function get_post_terms($postid){
		$result="";

		if (strlen($this->filtertax)>0){
			$terms= get_the_terms( $item->ID, $this->filtertax );
			foreach ($terms as $term){
				$result .= $term->slug . ";";
			}
		}
		return $result;
	}

}