<?php
/**
 * admin section of the plugin
 * v 1.0.0
 */
class mailbox_newschannel {
	var $category = "";
	var $tag = "";
	var $search = "";
	var $perpage = 10;
	var $order = "ASC";
	var $sort = "date";
	var $customfield="";
	var $customvalue = "";


	public function __construct() {
	}

	function get_data(){
		// WP_Query arguments

		$metaquery = '';
		if (strlen($this->customfield)>0){
			$metaquery = array(
					'key'       => $this->customfield,
					'value'     => $this->customvalue,
					'compare'   => 'LIKE'
			)
			;
		}

		$args = array (
				'post_type'              => 'Post',
				'category_name'          => $this->category,
				'tag'                    => $this->tag,
				's'                      => $this->search,
				'nopaging'               => true,
				'posts_per_page'         => $this->perpage,
				'order'                  => $this->order,
				'orderby'                => $this->sort,
				'meta_query'             => array($metaquery),
		);

		// The Query
		$query = new WP_Query( $args );

		// Restore original Post Data
		wp_reset_postdata();

		return $query;
	}

	private function add_css(){
		?>
		<style>
			.newsitem {margin-bottom:20px;}
			.newsitem > a.main_link {}
			.newsitem > a.main_link:hover .inner {background-color:rgba(210,210,210,0.4);}
			.newsitem .inner {width:100%;height:100%;}
			.newsitem .image {width:25%;float:left;}
			.newsitem .image img {width:100%;min-height:100%;overflow:hidden;}
			.newsitem .text {float:right;width:75%;padding:20px;}
			.newsitem .metadata {font-size:0.7em;float:right;}
			.newsitem .metadata a {text-decoration:none;}
		</style>
		<?php
	}

	private function add_javascript(){}

	public function show_data(){
		$data = $this->get_data();

		if ( $data->have_posts() ) {
			while ($data->have_posts()) {
				$data->the_post();
				$this->show_item();
			}

		}

		$this->add_css();
		$this->add_javascript();


	}

	private function show_item(){
		$newsitem = get_post(get_the_id());
		$feat_image = wp_get_attachment_url( get_post_thumbnail_id($newsitem->ID) );
		$content = get_the_content();
		$content = preg_replace("/<img[^>]+\>/i", "(image) ", $content);
		$content = str_replace(']]>', ']]>', $content);
	    $content = preg_replace('/<a href=\"(.*?)\">(.*?)<\/a>/', "\\2", $content);
		$content = str_replace('(image)', '', $content);
		$content =  substr($content, 0, 250);
		?>
		<div class="newsitem">
			<a class="main_link" href="<?php echo get_permalink(get_the_id());?>">
			<div class="inner clearfix">
				<div class="image"><img src="<?php echo $feat_image;?>" /></div>
				<div class="text">
					<div class="title"><?php the_title()?></div>
					<div class="excerpt"><?php echo $content;?></div>
					<div class="metadata">
						<?php the_time("d/m/Y");?>
						<?php //wp_list_categories('orderby=name&show_count=0&style=none'); ?>
					</div>
				</div>
			</div>
			</a>
		</div>
		<?php
	}

}