<?php
/**
 * media management
 * v 1.0.0
 */

if (get_option("activateMediaMgt")=='1'){
	$mediamgt = new mailbox_media_management();
	$mediamgt->start();
}

class mailbox_media_management {


	public function __construct() {
		add_action('init',array($this,'add_tags'));
		add_action('init',array($this,'add_categories'));
	}

	public function start(){
		add_shortcode('mailbox_tag_gallery',array($this,'tag_gallery'));
		add_shortcode('mailbox_category_gallery',array($this,'category_gallery'));
		add_action( 'wp_enqueue_scripts', array($this,'add_css_and_scripts' ));
	}

	//function add css
	function add_css_and_scripts(){
		//media styles
		wp_register_style('mailbox-media', plugins_url() .  '/mailbox/assets/mediamanagement.css');
		wp_enqueue_style('mailbox-media');

		//media jquery
		wp_register_script('mailbox-media-jquery',plugins_url()  .  '/mailbox/assets/mediamanagement.js');
		wp_enqueue_script( 'mailbox-media-jquery');
	}

	//gets the data
	function show_data($mediatype,$slug){
		$myposts =
		get_posts(array(
				'showposts' => -1,
				'post_type' => 'attachment',
				'tax_query' => array(
						array(
								'taxonomy' => $mediatype,
								'field' => 'slug',
								'terms' => array($slug))
				))
		);

		return $myposts;
	}

	//show the thumbnail
	function show_thumb($image,$width,$margin){

		$img_url= wp_get_attachment_image_src($image->ID,"medium");
		$img_large = wp_get_attachment_image_src($image->ID,"large");
		?>
			<div class='item' style="width:<?php echo $width;?>;">
				<div
					title="<?php echo $image->post_title; ?>"
					src="<?php echo $img_large[0]; ?>"
					class="item-image fancybox"
					style="background-image:url('<?php echo $img_url[0]; ?>');width:<?php echo $margin?>;height:<?php echo $margin?>;">
				</div>
			</div>
		<?php
	}

	//function for the category gallery
	function category_gallery($atts){
		$atts = shortcode_atts(array(
				'keyword' => '',
				'width'=>'33%',
				'margin'=>'2%',
				'background'=>'rgba(256,256,256,0.5)',
				'ratio'=>'1',
		), $atts);

		$myposts = $this->show_data("media_category", $atts["keyword"]);
		$varWidth=100-$atts["margin"] . "%";

		ob_start();

		//custom css + hidden field
		?>

		<style>
			div.mb_gallery div.item .item-image:after {background:<?php echo $atts["background"]?>;}
		</style>
		<?php

		echo "<div class='mb_gallery' data-ratio='" . $atts["ratio"] . "'><div class='row clearfix'>";
		foreach($myposts as $image){
			$this->show_thumb($image,$atts["width"],$varWidth);
		}
		echo "</div></div>";

		$sc = ob_get_contents();
		ob_end_clean();

		return $sc;
	}

	//function for the tag gallery
	function tag_gallery($atts){
		$atts = shortcode_atts(array(
				'keyword' => '',
				'width'=>'33%',
				'margin'=>'2%',
				'background'=>'rgba(256,256,256,0.5)',
				'ratio'=>'1',
		), $atts);

		$myposts = $this->show_data("media_tag", $atts["keyword"]);
		$varWidth=100-$atts["margin"] . "%";

		ob_start();

		//custom css
		?>
		<style>
			div.mb_gallery div.item .item-image:after {background:<?php echo $atts["background"]?>;}
		</style>
		<?php

		echo "<div class='mb_gallery' data-ratio='" . $atts["ratio"] . "'><div class='row clearfix'>";
		foreach($myposts as $image){
			$this->show_thumb($image,$atts["width"],$varWidth);
		}
		echo "</div></div>";

		$sc = ob_get_contents();
		ob_end_clean();

		return $sc;
	}

	//adds categories to media
	function add_categories(){
		$labels = array(
				'name'              => 'media-categories',
				'singular_name'     => 'media-category',
				'search_items'      => 'Search Media Categories',
				'all_items'         => 'All Media Categories',
				'parent_item'       => 'Parent Media Category',
				'parent_item_colon' => 'Parent Media Category:',
				'edit_item'         => 'Edit Media category',
				'update_item'       => 'Update Media category',
				'add_new_item'      => 'Add New Media category',
				'new_item_name'     => 'New Media Category',
				'menu_name'         => 'Media category',
		);

		$args = array(
				'labels' => $labels,
				'hierarchical' => true,
				'query_var' => 'true',
				'rewrite' => 'true',
				'show_admin_column' => 'true',
		);

		register_taxonomy( 'media_category', 'attachment', $args );
	}

	//adds tags to media
	function add_tags() {
		$labels = array(
				'name'              => 'media-tags',
				'singular_name'     => 'media-tag',
				'search_items'      => 'Search Media Tags',
				'all_items'         => 'All Media Tags',
				'parent_item'       => 'Parent Media Tag',
				'parent_item_colon' => 'Parent Media Tag:',
				'edit_item'         => 'Edit Media tag',
				'update_item'       => 'Update Media tag',
				'add_new_item'      => 'Add New Media Tag',
				'new_item_name'     => 'New Media Tag',
				'menu_name'         => 'Media tag',
		);

		$args = array(
				'labels' => $labels,
				'hierarchical' => false,
				'query_var' => 'true',
				'rewrite' => 'true',
				'show_admin_column' => 'true',
		);

		register_taxonomy( 'media_tag', 'attachment', $args );
	}
}