<?php

//set frontend scripts & css
function maibox_enqueue_frontend() {


	//custom css
	wp_register_style('mailbox-custom-css', plugins_url() .  '/mailbox/assets/mailbox-custom.css');
    wp_enqueue_style( 'mailbox-custom-css');

    //grid css
    wp_register_style('mailbox-grid-css', plugins_url() .  '/mailbox/assets/grid.css');
    wp_enqueue_style( 'mailbox-grid-css');

    //mailbox btn and tag styles
    if (get_option( 'ExtraCss' )=='1'){
    	wp_register_style('mailbox-extra', plugins_url()  .  '/mailbox/assets/extra.css');
    	wp_enqueue_style( 'mailbox-extra');
    }

	//jquery latest version
	if (get_option( 'JQlatest' )=='1'){
	wp_register_script ('jquerylatest' , '//code.jquery.com/jquery-1.11.1.min.js');
	wp_enqueue_script ('jquerylatest') ;
    }

	//font awesome
	if (get_option( 'JQFontAwesome' )=='1'){
	wp_register_style('Font Awesome','//maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css');
    wp_enqueue_style( 'Font Awesome');
	}

	//slabtext
	if (get_option( 'JQSlabText' )=='1'){
	wp_register_script('slabtext',plugins_url()  .  '/mailbox/assets/jquery.slabtext.min.js');
    wp_enqueue_script( 'slabtext');
	}

	//flowtype
	if (get_option( 'JQflowtype' )=='1'){
	wp_register_script('flowtype',plugins_url()  .  '/mailbox/assets/flowtype.js');
    wp_enqueue_script( 'flowtype');
	}

	//fancybox
	if (get_option( 'JQfancy' )=='1'){
	wp_register_script('JQfancyS',plugins_url()  .  '/mailbox/assets/jquery.fancybox.js');
    wp_enqueue_script( 'JQfancyS');

	wp_register_style('JQfancyC', plugins_url() .  '/mailbox/assets/jquery.fancybox.css');
    wp_enqueue_style( 'JQfancyC');
	}
	
	//material design
	if (get_option( 'Material' )=='1'){
			
		wp_register_style('MaterialIcons', 'https://fonts.googleapis.com/icon?family=Material+Icons');
		wp_enqueue_style( 'MaterialIcons');
		
		wp_register_style('MaterialCss', 'https://cdnjs.cloudflare.com/ajax/libs/materialize/0.98.2/css/materialize.min.css');
		wp_enqueue_style( 'MaterialCss');
	}
	

	//textfill
	if (get_option( 'JTextfill' )=='1'){
	wp_register_script('JTextfill',plugins_url()  .  '/mailbox/assets/jquery.scaletext.js');
    wp_enqueue_script( 'JTextfill');
	}

	//mailbox custom jquery functions
	wp_register_script ('mailbox-custom-jquery' ,  plugins_url()  .   '/mailbox/assets/jqueryfunctions.js');
	wp_enqueue_script( 'mailbox-custom-jquery');

	//mailbox contact form7
	wp_register_style('mailbox-custom-contactform7',  plugins_url()  .  '/mailbox/assets/contact_form7.css');
    wp_enqueue_style( 'mailbox-custom-contactform7');	
	
}
add_action( 'wp_enqueue_scripts', 'maibox_enqueue_frontend' );

//set backend scripts & css

function mailbox_remove_old_css(){
	wp_deregister_style( 'mailbox_jquery_ui' );
	wp_deregister_script( 'jquery-ui' );
}
add_action('admin_enqueue_scripts','mailbox_remove_old_css');

function maibox_enqueue_backend_old(){

	//wp_register_style('mailbox_jquery_ui', 'https://code.jquery.com/ui/1.11.2/themes/smoothness/jquery-ui.css');
    //wp_enqueue_style( 'mailbox_jquery_ui');

	//wp_enqueue_script('jquery-ui', 'https://code.jquery.com/ui/1.11.1/jquery-ui.min.js');
	//wp_enqueue_script ('jquery-ui') ;

	//custom admin styles
	//if (get_option('AdminCss')=='1'){
		add_action('admin_head', 'mailbox_custom_admin_css');

		function mailbox_custom_admin_css() {
			?>
			<style>
			/* admin menu */
			#adminmenu li.wp-menu-separator{
				height: 1px;
				padding: 0;
				margin: 0 0 6px;
				cursor: inherit;
				background-color: rgb(97, 68, 68);
				margin-top: 5px;
				margin-bottom: 5px;
			}
			/* message from vc ultimate addons */
           #update-nag, .update-nag, .vc_license  {display:none;}
           .vc_license-activation-notice {display:none;}
			</style>
			<?php
			}
		//}

}
//add_action('admin_enqueue_scripts','maibox_enqueue_backend');

//hide wp types agressive post details popup
add_filter('types_information_table', '__return_false');

//hide admin bar
function mailbox_function_show_admin_bar(){
	if (get_option( 'hideAdminBar' )=='1')
	{
		return false;
	}

	return true;

}
add_filter( 'show_admin_bar', 'mailbox_function_show_admin_bar' );

#force no comments
function mailbox_remove_comment_form_posts_pages() {
if (get_option( 'forceNoComments' )=='1')
	{
		remove_post_type_support( 'page', 'comments' );
		remove_post_type_support( 'post', 'comments' );
		add_filter('comments_open', '__return_false');
		update_option( 'default_comment_status', 'closed' );
        $post_types = get_post_types( '', 'names' );
        foreach ( $post_types as $post_type ) {
            remove_post_type_support($post_type,'comments');
        }
	}
}
add_action( 'init', 'mailbox_remove_comment_form_posts_pages' );

#convert symbols to html encoded strings
function mailbox_replace_smart_chars( $str ) {

	// Replace the smart quotes that cause question marks to appear
	$str = str_replace(
		array("\xe2\x80\x98", "\xe2\x80\x99", "\xe2\x80\x9c", "\xe2\x80\x9d", "\xe2\x80\x93", "\xe2\x80\x94", "\xe2\x80\xa6"),
		array("&lsquo;", "&rsquo;", '&ldquo;', '&rdquo;', '&ndash;', '&ndash;', '...'), $str);

	// Replace the smart quotes that cause question marks to appear
	$str = str_replace(
		array(chr(145), chr(146), chr(147), chr(148), chr(150), chr(151), chr(133)),
		array("&lsquo;", "&rsquo;", '&ldquo;', '&rdquo;', '&ndash;', '&ndash;', '...'), $str);

	// Replace special chars (tm) (c) (r)
	$str = str_replace(
		array('™', '©', '®'),
		array('&trade;', '&copy;', '&reg;'), $str);

	// Return the fixed string
	return $str;
}

// Add filters to modify the content before saving to the database
//add_filter( 'content_save_pre',	'mailbox_replace_smart_chars' );
//add_filter( 'title_save_pre',	'mailbox_replace_smart_chars' );

#sets wp heartbeat intervals
function mailbox_heartbeat_settings( $settings ) {
    $settings['interval'] = get_option("heartbeat"); //Anything between 15-60
    return $settings;
}
add_filter( 'heartbeat_settings', 'mailbox_heartbeat_settings' );

#shows or hides WP Time Capsule
add_action( 'admin_menu', 'my_remove_menu_pages', 999 );

function my_remove_menu_pages() {
	if (get_option( 'wptc' )=='1'){
	remove_menu_page( 'wp-time-capsule-monitor' );	
	}
};

#hides wp time capsule in list of plugins
function hide_plugin_trickspanda() {
	if (get_option( 'wptc' )=='1'){
	global $wp_list_table;
	$hidearr = array('wp-time-capsule/wp-time-capsule.php');
	$myplugins = $wp_list_table->items;
	foreach ($myplugins as $key => $val) {
		if (in_array($key,$hidearr)) {
			unset($wp_list_table->items[$key]);
		}
	}
	}
}
add_action('pre_current_active_plugins', 'hide_plugin_trickspanda');



