<?php

//custom types & views

#shows the current taxonomy term on an archive page
function mailbox_show_curent_tax() {
 echo "ok";
  if( is_tax() ) {
    global $wp_query;
    $term = $wp_query->get_queried_object();
    return $term->name;
  }
}
add_shortcode('mailbox_tax_name', 'mailbox_show_curent_tax');

//return the current taxonomy description
function mailbox_show_curent_tax_description() {
  if( is_tax() ) {
    global $wp_query;
    $term = $wp_query->get_queried_object();
    return $term->description;
  }
}
add_shortcode('mailbox_tax_description', 'mailbox_show_curent_tax_description');

#return the image associated to a custom taxonomy
function mailbox_show_current_tax_image($atts) {
global $WP_Views, $wp_query;
$term = $WP_Views ->get_current_taxonomy_term();
$wp_query->queried_object = $term;
return apply_filters( 'taxonomy-images-queried-term-image', '', array( 'image_size' => 'medium') );
}
add_shortcode('mailbox_tax_image', 'mailbox_show_current_tax_image');

//creates an online pdf viewer
function mailbox_pdf_function($attr, $url) {
   extract(shortcode_atts(array(
       'width' => '640px',
       'minheight' => '480px'
   ), $attr));
   return '<iframe src="http://docs.google.com/viewer?url=' . $url . '&embedded=true" style="width:' .$width. '; min-height:' .$minheight. ';">Your browser does not support iframes</iframe>';
}
add_shortcode('mailbox_pdf', 'mailbox_pdf_function');

//returns the tags for the current post
function mailbox_post_tags($atts){
$content = '';
$id = get_the_ID();

$posttags = get_the_tags($id);

	if ($posttags) {
	  $content = $content .  '<div class="tagcloud">';

	  foreach($posttags as $tag) {
		$content = $content . '<a href="' . get_tag_link($tag->term_id) . '">' . $tag->name . '</a>';
	  }

	  $content = $content . '</div>';
	 }

return $content;
}
add_shortcode('mailbox_tagcloud', 'mailbox_post_tags');

//remove empty p tags
add_filter( 'the_content', 'mailbox_remove_empty_p', 20, 1 );
function mailbox_remove_empty_p( $content ){
	// clean up p tags around block elements
	$content = preg_replace( array(
		'#<p>\s*<(div|aside|section|article|header|footer)#',
		'#</(div|aside|section|article|header|footer)>\s*</p>#',
		'#</(div|aside|section|article|header|footer)>\s*<br ?/?>#',
		'#<(div|aside|section|article|header|footer)(.*?)>\s*</p>#',
		'#<p>\s*</(div|aside|section|article|header|footer)#',
	), array(
		'<$1',
		'</$1>',
		'</$1>',
		'<$1$2>',
		'</$1',
	), $content );

	return preg_replace('#<p>(\s|&nbsp;)*+(<br\s*/*>)*(\s|&nbsp;)*</p>#i', '', $content);
}

//alphabetical list of posts
function mailbox_post_index($atts,$content){
$atts = shortcode_atts(array(
            'slug' => 'post',
			'qty' => '10',
        ), $atts);

		ob_start();
		echo "<div class='index'>";
		$args = array( 'post_type' => "'" . $atts["slug"]  . "'", 'posts_per_page' => 10,'orderby'=> 'title','order' => 'ASC',);
		$loop = new WP_Query( $args );
		$curr_letter='';
		while ( $loop->have_posts() ) : $loop->the_post();
		  $first_letter = strtoupper(substr(get_the_title(),0,1));

		  if ($first_letter != $curr_letter){

			if (strlen($curr_letter)!==0){echo "</div></div>";}
			$curr_letter = $first_letter;
			echo "<div class='index-item' data-letter='" . $curr_letter . "'>";
			echo "<div class='index-item-letter'>" . $curr_letter . "</div>";
			echo "<div class='index-item-content'>";
		  }
		  ?>
		  <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a>
		  <?php

		endwhile;
		echo "</div>";

		echo "<style>";
		?>
		.index-item{float: left;border-top: 1px solid #d2d2d2;width:100%;}
		.index-item-letter{width: 65px;float: left;font-size: 60px;line-height: 1.5em;margin: 0 0 0 15px;font-family: 'Droid Serif', serif;color: #231f20;font-weight:bold;border-right: 1px solid #d2d2d2;}
		.index-item-content{float: left;margin: 0px 0 0 0px;padding: 15px 0 15px 20px;font-size: 14px;min-height: 60px;}
		<?php
		echo "</style>";


		$sc = ob_get_contents();
		ob_end_clean();
		return $sc;
}
add_shortcode('mailbox_index', 'mailbox_post_index');

//gets thumbnails of subpages of a certain page
function mailbox_subpages($atts){
	$atts = shortcode_atts(array(
			'cta' => '',
			'page_id' => get_the_id(),
	), $atts);

	ob_start();

	$args = array(
			'posts_per_page'   => 100,
			'offset'           => 0,
			'category'         => '',
			'category_name'    => '',
			'custom-tax-name'  => '',
			'orderby'          => 'post_date',
			'order'            => 'ASC',
			'include'          => '',
			'exclude'          => '',
			'meta_key'         => '',
			'meta_value'       => '',
			'post_type'        => 'page',
			'post_mime_type'   => '',
			'post_parent'      => $atts["page_id"],
			'post_status'      => 'publish',
			'suppress_filters' => true
	);

	$subs = get_posts( $args, $content );

	echo "<div class='mb-subpages clearfix'>";
	foreach($subs as $sub){
		$exc = $sub->post_excerpt;

		if (strlen($exc)==0){
			$exc = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque sit amet commodo nisl, in
					vulputate dui. Vestibulum mollis turpis quis consectetur finibus. Aliquam viverra ex in nunc condimentum,
					id dictum lectus lacinia. Sed id risus ac tellus malesuada semper. Donec porttitor consequ";
		}
		?>
		<div class="mb-subpage">
		  <div class="inner">
		  <a href="<?php echo get_permalink($sub->ID) ?>">
		  <h4><?php echo $sub->post_title?></h4>
		  <p><?php echo $exc?></p>
		  </a>
		  </div>
		</div>
	  <?php
	}

	  if (strlen($atts["cta"])>0){
		?>
		<div class="dienst">
		  	<div class="inner dark">
			  <a href="/contact">
				<h4><?php echo $atts["cta"] ?></h4>
				<p><?php echo $content ;?></p>
			  </a>
		    </div>
		</div>
		<?php
	  }

	echo "</div>";

	$sc = ob_get_contents();
	ob_end_clean();

	return $sc;
}
add_shortcode('mailbox_subpages', 'mailbox_subpages');

//shows a grid of a post selection
function mailbox_postgrid($atts){
	$atts = shortcode_atts(array(
			'posttypes' =>'',
			'taxonomy' => '',
			'terms' =>'',
			'tags' => '',
			'categories' => '',
			'sort' => "date",
			'order' => "DESC",
			'status' => "publish",
			'search' => "",
			'customfield'=> "",
			'customvalue' => "",
			'parent' => "",
			'perpage' => "100",
			'paged' => "0",
			'placeholder' => "div",
			'width' => "50%",
			'border' => "1px solid #efefef",
			'padding' => "10px",
			'excerpt' => 20,
			'imgbackground' => "#ffffff",
			'margin' => "0 10px 15px 0",
			'filtertax' =>"",
			'custommeta' =>"",
			'height' =>"auto",
			'imageheight' =>'auto',
			'class' => '',
			'link' => '',
			'more' => '',
	), $atts);

	ob_start();
	
	

	$grid = new mailbox_grid();
	$grid->posttypes = $atts["posttypes"];
	$grid->width = $atts["width"];
	$grid->excerpt = $atts["excerpt"];
	$grid->taxonomy = $atts["taxonomy"];
	$grid->terms = $atts["terms"];
	$grid->filtertax = $atts["filtertax"];
	$grid->tags = $atts["tags"];
	$grid->sort = $atts["sort"];
	$grid->order = $atts["order"];
	$grid->status = $atts["status"];
	$grid->perpage = $atts["perpage"];
	$grid->paged = $atts["paged"];
	$grid->placeholder = $atts["placeholder"];
	$grid->border = $atts["border"];
	$grid->padding = $atts["padding"];
	$grid->custommeta = $atts["custommeta"];
	$grid->customfield = $atts["customfield"];
	$grid->customvalue = $atts["customvalue"];
	$grid->categories = $atts["categories"];
	$grid->parent = $atts["parent"];
	$grid->height = $atts["height"];
	$grid->imageheight = $atts["imageheight"];
	$grid->class = $atts["class"];
	$grid->link = $atts["link"];
	$grid->more = $atts["more"];
	$grid->search = $atts["search"];

	$grid->start();
	$grid->create_grid();

	$sc = ob_get_contents();
	ob_end_clean();

	return $sc;
}
add_shortcode('mailbox_postgrid', 'mailbox_postgrid');

//shows a grid of images attached to a post
function mailbox_post_images($atts){
	$atts = shortcode_atts(array(
			'postid' =>0,
			'width' => '33%',
			'border' =>'',
			'padding' => '20px',
			'background' => '',
			'opacity' => "",
			'fontsize' => "",
			'fontcolor' => "",
			'height'=>"25vh",

	), $atts);

	ob_start();

	if (get_the_id()>0) {$atts["postid"]=get_the_id();}

	$imagegrid = new mailbox_post_thumbs();
	$imagegrid->postid = $atts["postid"];
	$imagegrid->width = $atts["width"];
	$imagegrid->border = $atts["border"];
	$imagegrid->padding = $atts["padding"];
	$imagegrid->background = $atts["background"];
	$imagegrid->opacity = $atts["opacity"];
	$imagegrid->fontsize = $atts["fontsize"];
	$imagegrid->fontcolor = $atts["fontcolor"];
	$imagegrid->height = $atts["height"];

	$imagegrid->get_thumbs();

	$sc = ob_get_contents();
	ob_end_clean();

	return $sc;
}
add_shortcode('mailbox_postimages', 'mailbox_post_images');

//shows a list of newsitems
function maibox_show_news($atts, $content = ''){

	$atts = shortcode_atts(array(
			'category' => '',
			'tag' => '',
			'search' => '',
			'perpage' => '',
			'order' => 'ASC',
			'sort' => 'date',
			'customfield' => '',
			'customvalue' => '',
	), $atts);

	ob_start();

	$newsreader = new mailbox_newschannel();
	$newsreader->category = $atts["category"];
	$newsreader->tag = $atts["tag"];
	$newsreader->search = $atts["search"];
	$newsreader->perpage = $atts["perpage"];
	$newsreader->order = $atts["order"];
	$newsreader->sort = $atts["sort"];
	$newsreader->customfield = $atts["customfield"];
	$newsreader->customvalue = $atts["customvalue"];

	$newsreader->show_data();

	$sc = ob_get_contents();
	ob_end_clean();

	return $sc;
}
add_shortcode('news', 'maibox_show_news');

?>