<?php

#include form
require_once dirname( __FILE__ ) .'/mailbox-form.php';

#initialization
add_action('admin_init','mailbox_admin_init');
add_action('admin_menu','mailbox_setForm');

#initialize admin section
function mailbox_admin_init(){	
	register_setting( 'Mailbox', 'forceNoComments' ); //register the force no comments setting
	register_setting( 'Mailbox', 'keywords' ); //register the keywords setting
	register_setting( 'Mailbox', 'hideAdminBar' ); //register the keywords setting
	register_setting( 'Mailbox', 'CustomLogin' ); //register the keywords setting
	add_filter('widget_text', 'do_shortcode'); //allows shortcode in widgets	
	remove_action('wp_head', 'wp_generator'); //do not show wordpress version number = security feauture	
	add_theme_support ( 'post-thumbnails' ) ; //adds featured images to all post types
	
}

//allows the use of shortcode in contactform
function mailbox_mycustom_wpcf7_form_elements( $form ) {
	$form = do_shortcode( $form );
	return $form;
}
add_filter( 'wpcf7_form_elements', 'mailbox_mycustom_wpcf7_form_elements' );

#admin form
function mailbox_setForm()
{
add_submenu_page( 'options-general.php', 'Mailbox', 'Mailbox', 'manage_options', 'mailbox-form', 'my_form' ); //sets and adds the form to the admin section
}

?>
