<?php

//schema's
//http://schema.org/Person
//http://schema.org/LocalBusiness
//http://schema.org/PostalAddress
//http://schema.org/Store
//http://schema.org/Product

//SHORTCODES 
//person shortcode
function maibox_micro_formats_shortcode_person($atts, $content = ''){
		$atts = shortcode_atts(array(
            'placeholder' => 'section',
            'email' => '',
			'lastname' => '',
			'firstname' => '',
			'image'=>'',
			'title'=>'',
			'url'=>'',
			'telephone'=>'',	
			'twitter'=>'',	
			'facebook'=>'',	
			'linkedin'=>'',
			'googleplus'=>'',	
			'class'=>'',	
        ), $atts);
		
		ob_start();	
		
		echo "<" . $atts["placeholder"] . " class='micro-format " .  $atts["class"] . "' itemscope itemtype='http://schema.org/Person'>";
		echo maibox_micro_formats_setProperty("lastname",$atts["lastname"]);		
		echo maibox_micro_formats_setProperty("firstname",$atts["firstname"]);
		echo maibox_micro_formats_setProperty("description",$content);	
		echo maibox_micro_formats_setProperty("image",$atts["image"]);
		echo maibox_micro_formats_setProperty("title",$atts["title"]);
		echo maibox_micro_formats_setProperty("url",$atts["url"]);
		echo maibox_micro_formats_setProperty("email",$atts["email"]);
		echo maibox_micro_formats_setProperty("telephone",$atts["telephone"]);	

		//social media
		echo "<div class='social'>";
			echo maibox_micro_formats_setProperty("twitter",$atts["twitter"]);
			echo maibox_micro_formats_setProperty("facebook",$atts["facebook"]);
			echo maibox_micro_formats_setProperty("linkedin",$atts["linkedin"]);
			echo maibox_micro_formats_setProperty("googleplus",$atts["googleplus"]);
		echo "</div>";
		
		echo "</" . $atts["placeholder"] . ">";
					
		$sc = ob_get_contents();
		ob_end_clean();
		
		return $sc;
}
add_shortcode('person', 'maibox_micro_formats_shortcode_person');

//organization shortcode
function maibox_micro_formats_shortcode_organization($atts,$content = ''){
		$atts = shortcode_atts(array(
            'placeholder' => 'section',
            'name' => '',
			'vat' => '',
			'logo' => '',
			'telephone' => '',
			'email' => '',
			'url' => '',
			'class'=>'',
			'namenode'=>'',
			'description'=>'',
        ), $atts);
		
		ob_start();	
		
		if (strlen($atts['description'])>0){$content=$atts["description"];}		
		if (strlen($atts['namenode'])>0){$atts['name']='<' . $atts['namenode'] . '>' . $atts['name'] . '</' . $atts['namenode'] . '>'; }
		
		echo "<" . $atts["placeholder"] . " class='micro-format' itemscope itemtype='http://schema.org/LocalBusiness'>";		
		echo maibox_micro_formats_setProperty("name",$atts["name"]);	
		echo maibox_micro_formats_setProperty("description",$content);		
		echo maibox_micro_formats_setProperty("vat",$atts["vat"]);
		echo maibox_micro_formats_setProperty("logo",$atts["logo"]);
		echo maibox_micro_formats_setProperty("telephone",$atts["telephone"]);
		echo maibox_micro_formats_setProperty("email",$atts["email"]);
		echo maibox_micro_formats_setProperty("url",$atts["url"]);			
		echo "</" . $atts["placeholder"] . ">";
		
		$sc = ob_get_contents();
		ob_end_clean();
		
		return $sc;
}
add_shortcode('organization', 'maibox_micro_formats_shortcode_organization');

//address shortcode
function maibox_micro_formats_shortcode_address($atts,$content = ''){
		$atts = shortcode_atts(array(
            'placeholder' => 'address',
            'street' => '',
			'zip' => '',
			'locality' => '',
			'country' => '',			
			'class'=>'',
        ), $atts);
		
		
		
		ob_start();	
		
		echo "<" . $atts["placeholder"] . " class='micro-format address " .  $atts["class"] . "' itemscope itemtype='http://schema.org/PostalAddress'>";		
		echo maibox_micro_formats_setProperty("street",$atts["street"]);	
		echo maibox_micro_formats_setProperty("zip",$atts["zip"]);		
		echo maibox_micro_formats_setProperty("locality",$atts["locality"]);
		echo maibox_micro_formats_setProperty("country",$atts["country"]);			
		echo "</" . $atts["placeholder"] . ">";
		
		$sc = ob_get_contents();
		ob_end_clean();
		
		return $sc;

		
		return $content;
}
add_shortcode('postaddress', 'maibox_micro_formats_shortcode_address');

function maibox_micro_formats_setProperty($name,$value){
	$placeholderStart = "<span";
	$placeholderStop = "</span>";	
	
	$result="";
	if (strlen($value)>0){
	$result = $result . $placeholderStart . " itemprop='" . maibox_micro_formats_getxml_property($name)  . "' class='" . $name . "'>";
	$result = $result . maibox_micro_formats_getvalue($name,$value);
	$result = $result . $placeholderStop;
	}
	return $result;
}

function maibox_micro_formats_setPropertyOLD_deprecated($name, $value){

	$placeholderStart = "<span";
	$placeholderStop = "</span>";	
		
		
	if (strlen($value)>0){
		?>
			<?php echo $placeholderStart ?> itemprop='<?php echo maibox_micro_formats_getxml_property($name) ;?>' class='<?php echo $name  ?>'>
				<?php echo maibox_micro_formats_getvalue($name,$value); ?>
			<?php echo $placeholderStop ?>
		<?php
	}
}

//opening hours
function maibox_micro_formats_shortcode_opening_hours($atts,$content = ''){
		$atts = shortcode_atts(array(
            'placeholder' => 'section',
            'mo' => '',
			'tu' => '',
			'we' => '',
			'th' => '',
			'fr' => '',
			'sa' => '',
			'su' => '',
			'week' =>'',
			'class'=>'',
        ), $atts);
		
		$week=$atts["week"];	
		if(strlen($week)==0){$week = get_option('mailbox_micro_formats_opening_hours');}
		
		$weekhours = explode("-", $week);
		
		//week
		$mo= "mo" . ";" . $weekhours[0] . ";" . $weekhours[1];
		$tu= "tu" . ";" . $weekhours[0] . ";" . $weekhours[1];
		$we= "we" . ";" . $weekhours[0] . ";" . $weekhours[1];
		$th= "th" . ";" . $weekhours[0] . ";" . $weekhours[1];
		$fr= "fr" . ";" . $weekhours[0] . ";" . $weekhours[1];
		
		//weekend
		if (get_option('mailbox_micro_formats_include_weekend')==1){
		$sa= "sa" . ";" . $weekhours[0] . ";" . $weekhours[1];
		$su= "su" . ";" . $weekhours[0] . ";" . $weekhours[1];
		}
		
		//week
		if (strlen($atts["mo"])>0){$hours = explode("-", $atts["mo"]); $mo= "mo" . ";" . $hours[0] . ";" . $hours[1];}
		if (strlen($atts["tu"])>0){$hours = explode("-", $atts["mo"]); $tu= "tu" . ";" . $hours[0] . ";" . $hours[1];}
		if (strlen($atts["we"])>0){$hours = explode("-", $atts["mo"]); $we= "we" . ";" . $hours[0] . ";" . $hours[1];}
		if (strlen($atts["th"])>0){$hours = explode("-", $atts["mo"]); $th= "th" . ";" . $hours[0] . ";" . $hours[1];}
		if (strlen($atts["fr"])>0){$hours = explode("-", $atts["mo"]); $fr= "fr" . ";" . $hours[0] . ";" . $hours[1];}
		
		//weekend
		if (strlen($atts["sa"])>0){$hours = explode("-", $atts["mo"]); $sa= "sa" . ";" . $hours[0] . ";" . $hours[1];}
		if (strlen($atts["su"])>0){$hours = explode("-", $atts["mo"]); $su= "su" . ";" . $hours[0] . ";" . $hours[1];}
		
		ob_start();	
		
		
		
		echo "<" . $atts["placeholder"] . "  itemscope itemtype='http://schema.org/Store' class='micro-format " . $atts['class'] ."'>";		
		echo mailbox_micro_formats_create_hour($mo);
		echo mailbox_micro_formats_create_hour($tu);
		echo mailbox_micro_formats_create_hour($we);
		echo mailbox_micro_formats_create_hour($th);
		echo mailbox_micro_formats_create_hour($fr);
		echo mailbox_micro_formats_create_hour($sa);
		echo mailbox_micro_formats_create_hour($su);
		
		echo "</" . $atts["placeholder"] . ">";
		
		$sc = ob_get_contents();
		ob_end_clean();
		
		return $sc;		
		
}
add_shortcode('hours', 'maibox_micro_formats_shortcode_opening_hours');

//product
function maibox_micro_formats_shortcode_product($atts,$content = ''){
		$atts = shortcode_atts(array(
            'placeholder' => 'section',
			'name' => '',
			'description' => '',
            'logo' => '',
			'model' => '',
			'mpn' => '',
			'productcode' => '',			
			'class'=>'',
			'namenode'=>'',
        ), $atts);
		
		
		if (strlen($atts['description'])>0){$content=$atts["description"];}		
		if (strlen($atts['namenode'])>0){$atts['name']='<' . $atts['namenode'] . '>' . $atts['name'] . '</' . $atts['namenode'] . '>'; }
		
		ob_start();		
		
		//product
		echo "<" . $atts["placeholder"] . "  itemscope itemtype='http://schema.org/Product' class='micro-format " . $atts['class'] ."'>";		
			echo maibox_micro_formats_setProperty("name",$atts["name"]);
			echo maibox_micro_formats_setProperty("model",$atts["model"]);	
			echo maibox_micro_formats_setProperty("productcode",$atts["productcode"]);	
			echo maibox_micro_formats_setProperty("description",$content);	
			echo maibox_micro_formats_setProperty("logo",$atts["logo"]);				
		echo "</" . $atts["placeholder"] . ">";
		
		//manufacturer = mycompany
		echo do_shortcode("[mycompany / ]");
		
		$sc = ob_get_contents();
		ob_end_clean();
		
		return $sc;		
		
}
add_shortcode('product', 'maibox_micro_formats_shortcode_product');

//review
function maibox_micro_formats_shortcode_review($atts,$content = ''){
		$atts = shortcode_atts(array(
            'placeholder' => 'section',
            'logo' => '',
			'model' => '',
			'mpn' => '',
			'productID' => '',			
			'class'=>'',
        ), $atts);
		
		
		
		ob_start();	
		
		echo "<" . $atts["placeholder"] . "  itemscope itemtype='http://schema.org/Product' class='micro-format " . $atts['class'] ."'>";		
		echo "</" . $atts["placeholder"] . ">";
		
		$sc = ob_get_contents();
		ob_end_clean();
		
		return $sc;		
		
}
add_shortcode('review', 'maibox_micro_formats_shortcode_review');

//me shortcode
function mailbox_micro_formats_me($atts,$content=''){
	$atts = shortcode_atts(array(
            'email' => ''
        ), $atts);
		
		$user = get_user_by( 'email', $atts['email'] );
		$author_id= $user->ID;
		$shortcode = do_shortcode("[person class='author-bio' placeholder='section' twitter='" .  get_the_author_meta('twitter',$author_id) . "' facebook='" .  
							get_the_author_meta('last_name',$author_id) . "' googleplus='" .  get_the_author_meta('googleplus',$author_id) . "' linkedin='" .  get_the_author_meta('linkedin',$author_id) . "' lastname='" . get_the_author_meta('last_name',$author_id) . "' firstname='" . get_the_author_meta('first_name',$author_id) .  
						    "' email='" . get_the_author_meta('user_email',$author_id) . "'  url='" . get_the_author_meta('user_url',$author_id) . "'  description='" .  get_the_author_meta('description',$author_id) . "' /] ");
							
		return $shortcode;
}
add_shortcode('me', 'mailbox_micro_formats_me');

//mycompany shortcode
function mailbox_micro_formats_mycompany(){
	$shortcode = do_shortcode("[organization namenode='h2' description='" . get_option( 'description' )  . "' name='" . get_option( 'organization' ) . "' email='" . get_option( 'email' )  ."' url='" . get_option( 'url' )  . "' telephone='" . get_option( 'telephone' )  . "' /]");
	return $shortcode;
}
add_shortcode('mycompany', 'mailbox_micro_formats_mycompany');

//myaddress shortcode
function mailbox_micro_formats_myaddress(){
    $shortcode = do_shortcode("[postaddress street='" . get_option( 'street' ) . "' zip='" . get_option( 'zip' )  ."' locality='" . get_option( 'locality' )  . "' country='" . get_option( 'country' )  . "' /]");
	return $shortcode;
}
add_shortcode('myaddress', 'mailbox_micro_formats_myaddress');

//myhours shortcode
function mailbox_micro_formats_myhours($authorID){
	$shortcode = do_shortcode("[hours /]");
	return $shortcode;
}
add_shortcode('myhours', 'mailbox_micro_formats_myhours');

//INDIVIDUAL SHORTCODES
function mailbox_micro_formats_MF_company(){
	ob_start();	
	echo  '<span class=micro-format itemscope itemtype="http://schema.org/LocalBusiness">' ;
	echo maibox_micro_formats_setProperty("name",get_option('organization')) ;
	echo '</span>';					
	$sc = ob_get_contents();
	ob_end_clean();	
	return $sc;
}
add_shortcode('MFcompany', 'mailbox_micro_formats_MF_company');

function mailbox_micro_formats_MF_description(){
	ob_start();	
	echo  '<span class=microformat itemscope itemtype="http://schema.org/LocalBusiness">' ;
	echo maibox_micro_formats_setProperty("description",get_option('description')) ;
	echo '</span>';					
	$sc = ob_get_contents();
	ob_end_clean();	
	return $sc;
}
add_shortcode('MFdescription', 'mailbox_micro_formats_MF_description');

function mailbox_micro_formats_MF_telephone(){
	ob_start();	
	echo  '<span class=microformat itemscope itemtype="http://schema.org/LocalBusiness">' ;
	echo maibox_micro_formats_setProperty("telephone",get_option('telephone')) ;
	echo '</span>';					
	$sc = ob_get_contents();
	ob_end_clean();	
	return $sc;
}
add_shortcode('MFtelephone', 'mailbox_micro_formats_MF_telephone');

//SHORTCODE SUPPORT FUNCTIONS
//sets a property


//gets the value to set
function maibox_micro_formats_getvalue($name,$value){
	//$name=mb_strtolower($name,'UTF-8');
		
	switch ($name) {   
		
		case "url":
			$url = maibox_micro_formats_getIcon($name)  . "<a itemprop='url' href='" . $value . "' target='_blank'>" . $value ."</a>";
			return $url;
			break;	
			
		case "email":
			$url = maibox_micro_formats_getIcon($name)  . "<a itemprop='email' href='mailto:" . $value . "' target='_blank'>" . $value ."</a>";
			return $url;
			break;	
			
		case "logo":
			$url = "<img src='" . $value . "' ></img>";
			return $url;
			break;	

		case "twitter":
			return "<a target='_blank' href='" .  $value . "'>" . maibox_micro_formats_getIcon($name) . "</a>" ;
			break;
			
		case "facebook":
			return "<a target='_blank' href='" .  $value . "'>" . maibox_micro_formats_getIcon($name) . "</a>" ;
			break;
			
		case "googleplus":
			return "<a target='_blank' href='" .  $value . "'>" . maibox_micro_formats_getIcon($name) . "</a>" ;
			break;
			
		case "linkedin":
			return "<a target='_blank' href='" .  $value . "'>" . maibox_micro_formats_getIcon($name) . "</a>" ;
			break;
		   
		 default:
			//return maibox_micro_formats_getIcon($name)  .  $value;
			return $value;
			break;
	}
}

//get font awesome icon for micro formats
function maibox_micro_formats_getIcon($name){
	$name=mb_strtolower($name,'UTF-8');
		
	switch ($name) {   
		
		case "url":
			return "<i class='fa fa-home'></i>";
			break;	
		 
		 case "email":
			return "<i class='fa fa-envelope'></i>";
			break;
			
		case "title":
			//return "<i class='fa fa-briefcase'></i>";
			return "";
			break;
			
		case "telephone":
			return "<i class='fa fa-phone-square'></i>";
			break;
			
		case "name":
			return "";
			//return "<i class='fa fa-user'></i>";
			break;
			
		case "linkedin":
			return "<i class='fa fa-linkedin-square'></i>";
			break;
			
		case "facebook":
			return "<i class='fa fa-facebook-square'></i>";
			break;
			
		case "googleplus":
			return "<i class='fa fa-google-plus-square'></i>";
			break;
			
		case "twitter":
			return "<i class='fa fa-twitter-square'></i>";
			break;
			
		 default:	
			return "";
			break;
	}
}

//read schema.xml
function maibox_micro_formats_getxml_property($name){
	
	//$xml = simplexml_load_file("schema.xml") ;
	$name=mb_strtolower($name,'UTF-8');
		
	switch ($name) {
    case "lastname":
        return "familyName";
        break;
		
	case "image":
		return "image";
		break;
		
	case "title":
		return "jobTitle";
		break;
		
	case "url":
		return "url";
		break;	
		
    case "firstname":
        return "givenName";
        break;
		
    case "email":
       return "email";
       break;
	   
	 case "telephone":
		return "telephone";
		break;
		
	case "logo":
		return "logo";
		break;
		
	case "vat":
		return "vatID";
		break;
		
	case "productcode":
		return "productID";
		break;
		
		
	case "name":
		return "name";
		break;
		
	case "description":
		return "description";
		break;		
		
	case "street":
		return "streetAddress";
		break;
		
	case "zip":
		return "postalCode";
		break;
		
	case "locality":
		return "addressLocality";
		break;
		
	case "country":
		return "addressCountry";
		break;
	   
	 default:
		return $name;
		break;
}
	
}

//function to create a standard opening hour
function mailbox_micro_formats_create_hour($data){
	$result='';
	
	if(strlen($data)>0){
	$data = explode(";",$data);
	$day = $data[0];
	$start = $data[1];
	$stop = $data[2];
	
	$datetime = $day . " " . $start . ":00-" . $stop . ":00"; 
	$html = "<div class='day'>" . mailbox_micro_formats_getweekday($day) . "</div> :  " . $start . ".00" . " - " . $stop . ".00";
	
	$result = "<time class='hour' itemprop='openingHours' datetime='" .  $datetime . "'>" .  $html . "</time>";
	}
	
	return $result;
	
}

//function to retrieve the names of the weekdays
function mailbox_micro_formats_getweekday($dayshort){
	switch ($dayshort){
	
		case "mo":
			return esc_attr__("Monday");
			break;
		case "tu":
			return esc_attr__("Tuesday");
			break;
		case "we":
			return esc_attr__("Wednesday");
			break;
			
		case "th":
			return esc_attr__("Thursday");
			break;
			
		case "fr":
			return esc_attr__("Friday");
			break;
			
		case "sa":
			return esc_attr__("Saturday");
			break;
			
		case "su":
			return esc_attr__("Sunday");
			break;			
	}
}


//GENERAL FUNCTIONS

//create a kml file
function maibox_micro_formats_create_kmlfile(){
	//https://developers.google.com/kml/articles/phpmysqlkml?csw=1#outputkml
	//KML file
	$address = get_option('street') . ' ' . get_option('zip') . ' ' . get_option('locality') . '  ' . get_option('country');
	//$kmlfile = WP_PLUGIN_DIR . "/mailbox-micro-formats/includes/geodata.kml"; 
	
	$kmlfile = ABSPATH . "geodata.kml";	
		
	$dom = new DOMDocument('1.0', 'UTF-8');

	// Creates the root KML element and appends it to the root document.
	$node = $dom->createElementNS('http://www.opengis.net/kml/2.2', 'kml');
	$parNode = $dom->appendChild($node);

	// Creates a KML Document element and append it to the KML element.
	$dnode = $dom->createElement('Document');
	$docNode = $parNode->appendChild($dnode);
	
	//name node
	$namenode = maibox_micro_formats_create_xmlnode($dom,$docNode,'Name',get_option('organization') );	
	$placemark = maibox_micro_formats_create_xmlnode($dom,$docNode,'Placemark','');	
	
	$name = maibox_micro_formats_create_xmlnode($dom,$placemark,'name',get_option('organization') );	
	$description = maibox_micro_formats_create_xmlnode($dom,$placemark,'description',get_option('description') );	
	$addr = maibox_micro_formats_create_xmlnode($dom,$placemark,'address',$address);	
	$point = maibox_micro_formats_create_xmlnode($dom,$placemark,'point','');

	
	$geocode = maibox_micro_formats_geocode($address);
	$latitude = $geocode[0];
    $longitude = $geocode[1];
    
	$coordinates = maibox_micro_formats_create_xmlnode($dom,$point,'coordinates',$longitude . "," . $latitude);	
		
	$kmlOutput = $dom->saveXML();
	header('Content-type: application/vnd.google-earth.kml+xml');
	//return $kmlOutput;
	file_put_contents($kmlfile, $kmlOutput);	
	
	//GEO SITEMAP
	$geofile = ABSPATH .  "geositemap.xml";	
	$dom = new DOMDocument('1.0', 'UTF-8');

	// Creates the root KML element and appends it to the root document.
	$node = $dom->createElementNS('http://www.sitemaps.org/schemas/sitemap/0.9', 'urlset');
	$basenode = $dom->appendChild($node);
	
	//get_site_url() . "/geodata.kml"
	
	$url = maibox_micro_formats_create_xmlnode($dom,$basenode,'url');	
	$loc = maibox_micro_formats_create_xmlnode($dom,$url,'loc',get_site_url() . "/geodata.kml");	
	
	$xmlOutput = $dom->saveXML();
	//header('Content-type: application/vnd.google-earth.kml+xml');
	//return $kmlOutput;
	file_put_contents($geofile, $xmlOutput);	
	
}

function maibox_micro_formats_create_xmlnode($dom,$parnode,$name,$value){
	$newNode = $dom->createElement($name,$value);
	$new= $parnode->appendChild($newNode);
	return $new;
}

// function to geocode address, it will return false if unable to geocode address
function maibox_micro_formats_geocode($address){
 
    // url encode the address
    $address = urlencode($address);
     
    // google map geocode api url
    $url = "http://maps.google.com/maps/api/geocode/json?sensor=false&address={$address}";
	
	// get the json response
    $resp_json = file_get_contents($url);
     
    // decode the json
    $resp = json_decode($resp_json, true);
 
    // response status will be 'OK', if able to geocode given address 
    if($resp['status']='OK'){
 
		
        // get the important data
        $lati = $resp['results'][0]['geometry']['location']['lat'];
        $longi = $resp['results'][0]['geometry']['location']['lng'];
        $formatted_address = $resp['results'][0]['formatted_address'];
		
		
         
        // verify if data is complete
        if($lati && $longi && $formatted_address){
         
            // put the data in the array
            $data_arr = array();            
             
            array_push(
                $data_arr, 
                    $lati, 
                    $longi, 
                    $formatted_address
                );						
                     
			 return $data_arr;
             
        }else{
            return false;
        }
         
    }else{
        return false;
    }
}

//set frontend scripts & css 
add_action( 'wp_enqueue_scripts', 'maibox_micro_formats_enqueue_all' );
function maibox_micro_formats_enqueue_all() {
	wp_register_style('Font Awesome','//netdna.bootstrapcdn.com/font-awesome/4.0.3/css/font-awesome.css');
    wp_enqueue_style( 'Font Awesome');   	
	
	wp_register_style('mailbox_micro_formats', plugins_url() .  "/mailbox-micro-formats/includes/css/mailbox_micro_formats.css");
    wp_enqueue_style( 'mailbox_micro_formats');   

	wp_enqueue_script( 'mailbox_micro_formats_jquery', plugins_url() .  '"/mailbox-micro-formats/includes/js/mailbox-micro-formats.js', array(), '1.0.0', true );
	
}

//set backend scripts & css
add_action('admin_enqueue_scripts','maibox_micro_formats_enqueue_scripts');
function maibox_micro_formats_enqueue_scripts(){
	wp_register_style('mailbox_micro_formats', plugins_url() .  "/mailbox-micro-formats/includes/css/mailbox_micro_formats.css");
    wp_enqueue_style( 'mailbox_micro_formats'); 

	wp_register_style('mailbox_jquery_ui', 'https://code.jquery.com/ui/1.11.2/themes/smoothness/jquery-ui.css');
    wp_enqueue_style( 'mailbox_jquery_ui');   
	
	wp_enqueue_script('jquery-ui', 'https://code.jquery.com/ui/1.11.1/jquery-ui.min.js');
	wp_enqueue_script ('jquery-ui') ;
	
	wp_enqueue_script( 'mailbox_micro_formats_jquery', plugin_dir_url( __FILE__ ) .  'includes/js/mailbox-micro-formats.js', array(), '1.0.0', true );
}

//sets a author bio at the end of a post
function mailbox_micro_formats_author_bio($content){		
	if (get_option( 'add_bio' )=='1'){		
	global $post;
	$author_id=$post->post_author;	
	$shortcode = do_shortcode("[person class='author-bio' placeholder='section' lastname='" . get_the_author_meta('last_name',$author_id) . "' firstname='" . get_the_author_meta('first_name',$author_id) .  
						"' email='" . get_the_author_meta('user_email',$author_id) . "'  url='" . get_the_author_meta('user_url',$author_id) . "' /] ");
	return $content . $shortcode;
	}
	return $content;
}
add_filter( 'the_content', 'mailbox_micro_formats_author_bio' ); 

//removes author metabox in posts
function mailbox_micro_formats_remove_post_meta(){
	if (get_option( 'add_bio' )=='1'){
	remove_meta_box( 'authordiv','post' );
	}
}
add_action( 'add_meta_boxes', 'mailbox_micro_formats_author_bio' );

//adds extra fields for each user
function mailbox_micro_formats_custom_user_profile_fields($user){
?>
    <h3>Social Media</h3>
    <table class="form-table">
        <tr>
            <th><label for="linkedin">linkedin</label></th>
            <td>
                <input type="text" class="regular-text" name="linkedin" value="<?php echo esc_attr( get_the_author_meta( 'linkedin', $user->ID ) ); ?>" id="linkedin" />              
            </td>
        </tr>
		<tr>
            <th><label for="facebook">facebook</label></th>
            <td>
                <input type="text" class="regular-text" name="facebook" value="<?php echo esc_attr( get_the_author_meta( 'facebook', $user->ID ) ); ?>" id="facebook" />              
            </td>
        </tr>
		<tr>
            <th><label for="googleplus">Google+</label></th>
            <td>
                <input type="text" class="regular-text" name="googleplus" value="<?php echo esc_attr( get_the_author_meta( 'googleplus', $user->ID ) ); ?>" id="googleplus" />              
            </td>
        </tr>
		<tr>
            <th><label for="twitter">twitter</label></th>
            <td>
                <input type="text" class="regular-text" name="twitter" value="<?php echo esc_attr( get_the_author_meta( 'twitter', $user->ID ) ); ?>" id="twitter" />              
            </td>
        </tr>
    </table>
<?php
}

add_action( 'show_user_profile', 'mailbox_micro_formats_custom_user_profile_fields' );
add_action( 'edit_user_profile', 'mailbox_micro_formats_custom_user_profile_fields' );
add_action( "user_new_form", "mailbox_micro_formats_custom_user_profile_fields" );

//saves extra fields of a user to the database
function save_custom_user_profile_fields($user_id){
    # again do this only if you can
    if(!current_user_can('manage_options'))
        return false;

    # save my custom field
    update_usermeta($user_id, 'linkedin', $_POST['linkedin']);
	update_usermeta($user_id, 'facebook', $_POST['facebook']);
	update_usermeta($user_id, 'googleplus', $_POST['googleplus']);
	update_usermeta($user_id, 'twitter', $_POST['twitter']);
}
add_action('user_register', 'save_custom_user_profile_fields');







